/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWLoggingOptionType;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRosterElement;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.IVWAdminFieldChangeEventListener;
import filenet.vw.toolkit.admin.result.VWAdminFieldChangeEvent;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWFieldDataForTable;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.security.VWParticipantLabel;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;

public class VWAdminFieldsTableData
extends VWFieldDataForTable {
    protected static final Long NO_DATE = new Long("-2000000000000");
    protected static final Long NO_TIMER = new Long("2147483647000");
    protected static final Long NO_TIME = new Long("0");
    protected String m_properName;
    private String m_longName = null;
    private int m_type = 0;
    private Object m_value = null;
    private boolean m_bArray = false;
    private boolean m_bWritableField = false;
    private boolean m_bSystemField = false;
    protected boolean m_bModified;
    private Vector m_fieldChangeEventListeners = new Vector();
    private VWDataField m_vwData;
    private VWSession m_vwSession;
    private int m_vwType;
    private Object m_vwObject;

    public VWAdminFieldsTableData(VWDataField vwData, Object obj, VWSession session, int vwType) {
        super(vwData);
        try {
            this.m_vwData = vwData;
            this.m_vwObject = obj;
            this.m_vwSession = session;
            this.m_vwType = vwType;
            this.m_properName = vwData.getName();
            this.m_type = vwData.getFieldType();
            this.m_longName = vwData.getName();
            this.m_bArray = vwData.isArray();
            this.m_bWritableField = vwData.getIsWritable();
            this.m_bSystemField = vwData.getIsSystemField();
            this.initValue(vwData.getValue());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isModified() {
        return this.m_bModified;
    }

    public void setModified(boolean bModified) {
        this.m_bModified = bModified;
    }

    public String getLongName() {
        return this.m_longName;
    }

    public String getName() {
        return this.m_properName;
    }

    public String getAuthoredName() {
        if (this.m_vwData != null) {
            try {
                return this.m_vwData.getAuthoredName();
            }
            catch (VWException vWException) {
                // empty catch block
            }
        }
        return this.m_properName;
    }

    public void setValue(Object value) {
        this.m_value = value;
    }

    public boolean isArray() {
        return this.m_bArray;
    }

    public boolean isWritableField() {
        return this.m_bWritableField;
    }

    public int getType() {
        return this.m_type;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void writeDataFieldsToWorkObject(VWWorkObject wob) {
        if (wob == null) {
            return;
        }
        try {
            boolean bCompare = true;
            if (this.m_bArray && (this.m_type == 64 || this.m_type == 32)) {
                bCompare = false;
            }
            wob.setFieldValue(this.m_properName, this.m_value, bCompare);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
            VWDebug.logException(ex);
        }
    }

    public void fireFieldChangeEvent(int rowIndex) {
        VWAdminFieldChangeEvent event = new VWAdminFieldChangeEvent(this, this.getType());
        for (int i = 0; i < this.m_fieldChangeEventListeners.size(); ++i) {
            ((IVWAdminFieldChangeEventListener)this.m_fieldChangeEventListeners.elementAt(i)).fieldChanged(event, rowIndex);
        }
    }

    public void addFieldChangeEventListener(IVWAdminFieldChangeEventListener listener) {
        this.m_fieldChangeEventListeners.addElement(listener);
    }

    public void removeFieldChangeEventListener(IVWAdminFieldChangeEventListener listener) {
        this.m_fieldChangeEventListeners.removeElement(listener);
    }

    private void initValue(Object value) {
        try {
            if (value instanceof Date) {
                Date result = null;
                if (value != null && NO_DATE.longValue() != ((Date)value).getTime() && NO_TIME.longValue() != ((Date)value).getTime() && NO_TIMER.longValue() != ((Date)value).getTime()) {
                    result = (Date)value;
                }
                this.m_value = result;
                return;
            }
            if (this.m_bSystemField) {
                String authoredName = this.m_vwData.getAuthoredName();
                if (authoredName.equals("F_BoundUserId") || authoredName.equals("F_BoundUser") || authoredName.equals("F_UserId") || authoredName.equals("F_LockUser") || authoredName.equals("F_TransferUser") || authoredName.equals("F_Originator")) {
                    if (value instanceof Integer) {
                        VWParticipantItem pItem;
                        String displayName;
                        VWParticipant vwParticipant;
                        if ((Integer)value != -1 && (vwParticipant = this.m_vwSession.convertIdToUserNamePx(((Integer)value).intValue())) != null && (displayName = (pItem = new VWParticipantItem(vwParticipant)).getDisplayName()) != null) {
                            this.m_value = new VWParticipantLabel(value + " (" + displayName + ")");
                            ((VWParticipantLabel)this.m_value).setVWParticipant(vwParticipant);
                            return;
                        }
                    } else if (value instanceof VWParticipant) {
                        VWParticipant vwParticipant = (VWParticipant)value;
                        int userId = this.m_vwSession.convertUserNameToId(vwParticipant.getParticipantName());
                        VWParticipantItem pItem = new VWParticipantItem(vwParticipant);
                        String displayName = pItem.getDisplayName();
                        if (displayName != null) {
                            this.m_value = new VWParticipantLabel(userId + " (" + displayName + ")");
                            ((VWParticipantLabel)this.m_value).setVWParticipant(vwParticipant);
                            return;
                        }
                    }
                } else if (authoredName.equals("F_WorkClassId") || authoredName.equals("F_QueueWPClassId") || authoredName.equals("F_WPClassId")) {
                    boolean isQueue = !authoredName.equals("F_WorkClassId");
                    if (value instanceof Integer) {
                        String className = null;
                        if ((Integer)value != -1) {
                            className = this.m_vwSession.convertIdToClassName((Integer)value, isQueue);
                        }
                        if (className != null) {
                            this.m_value = value + " (" + className + ")";
                            return;
                        }
                    } else if (value instanceof String) {
                        int classId = this.m_vwSession.convertClassNameToId(value.toString(), isQueue);
                        this.m_value = classId + " (" + value.toString() + ")";
                        return;
                    }
                } else if (authoredName.equals("F_OperationId")) {
                    if (value instanceof Integer) {
                        String opName = null;
                        if (this.m_vwObject instanceof VWWorkObject) {
                            opName = ((VWWorkObject)this.m_vwObject).getOperationName();
                        } else if (this.m_vwObject instanceof VWLogElement) {
                            opName = ((VWLogElement)this.m_vwObject).getOperationName();
                        }
                        if (opName != null) {
                            this.m_value = value + " (" + opName + ")";
                            return;
                        }
                    }
                } else if (authoredName.equals("F_InstrSheetId")) {
                    if (value instanceof Integer) {
                        String sheetName = null;
                        if (this.m_vwObject instanceof VWLogElement) {
                            sheetName = ((VWLogElement)this.m_vwObject).getInstructionSheetName();
                        } else if (this.m_vwObject instanceof VWWorkObject) {
                            sheetName = ((VWWorkObject)this.m_vwObject).getInstructionSheetName();
                        }
                        if (sheetName != null) {
                            this.m_value = value + " (" + sheetName + ")";
                            return;
                        }
                    }
                } else if (authoredName.equals("F_EventType")) {
                    if (value instanceof Integer) {
                        String eventName = null;
                        if (this.m_vwObject instanceof VWLogElement) {
                            eventName = VWLoggingOptionType.getLocalizedString((Integer)value);
                        }
                        if (eventName != null) {
                            this.m_value = value + " (" + eventName + ")";
                            return;
                        }
                    }
                } else if (authoredName.equals("F_Subject")) {
                    if (this.m_vwObject instanceof VWWorkObject) {
                        this.m_value = ((VWWorkObject)this.m_vwObject).getSubject();
                        return;
                    }
                    if (this.m_vwObject instanceof VWRosterElement) {
                        this.m_value = ((VWRosterElement)this.m_vwObject).getSubject();
                        return;
                    }
                    if (this.m_vwObject instanceof VWLogElement) {
                        this.m_value = ((VWLogElement)this.m_vwObject).getSubject();
                        return;
                    }
                } else if (authoredName.equals("F_Operation")) {
                    if (this.m_vwObject instanceof VWWorkObject) {
                        this.m_value = ((VWWorkObject)this.m_vwObject).getOperationName();
                        return;
                    }
                } else if (authoredName.equals("F_Response")) {
                    Object resp;
                    if (this.m_vwObject instanceof VWWorkObject) {
                        this.m_value = ((VWWorkObject)this.m_vwObject).getSelectedResponse();
                        return;
                    }
                    if (this.m_vwObject instanceof VWLogElement && (resp = ((VWLogElement)this.m_vwObject).getFieldValue("F_Response")) != null && ((String)resp).length() > 0) {
                        this.m_value = ((VWLogElement)this.m_vwObject).getSelectedResponse();
                        return;
                    }
                } else if (authoredName.equals("F_Class")) {
                    if (this.m_vwObject instanceof VWWorkObject) {
                        this.m_value = ((VWWorkObject)this.m_vwObject).getWorkClassName();
                        return;
                    }
                } else if (authoredName.equals("F_InstrSheetName")) {
                    if (this.m_vwObject instanceof VWWorkObject) {
                        this.m_value = ((VWWorkObject)this.m_vwObject).getInstructionSheetName();
                        return;
                    }
                } else if (authoredName.equals("F_StepName")) {
                    if (this.m_vwObject instanceof VWWorkObject) {
                        this.m_value = ((VWWorkObject)this.m_vwObject).getStepName();
                        return;
                    }
                } else if (authoredName.equals("F_StepDescription") && this.m_vwObject instanceof VWWorkObject) {
                    this.m_value = ((VWWorkObject)this.m_vwObject).getStepDescription();
                    return;
                }
            }
            this.m_value = value != null && value instanceof VWParticipant[] ? VWDefaultSessionProxy.getFullParticipants((VWParticipant[])value, false) : value;
        }
        catch (Exception ex) {
            this.m_value = value;
            VWDebug.logException(ex);
        }
    }
}

